<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Dashboard</title>

    <!-- CSRF Token for AJAX Requests -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Bootstrap CSS CDN -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/css/bootstrap.min.css">

    <!-- Custom CSS for User Info and Balance Display -->
    <style>
        .user-info {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 1em;
            background-color: #f8f9fa;
        }

        .balance {
            font-size: 1.5em;
            color: #28a745;
        }

        .profile-logo img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
        }
    </style>

    <!-- Ad Script -->
    <script src='//niphaumeenses.net/vignette.min.js' data-zone='8445526' data-sdk='show_8445526'></script>
</head>

<body>

    <div class="container">
        <!-- User Info Section -->
        <div class="user-info mt-4">
            <div class="profile-logo">
                <img id="profile-image" src="" alt="Profile Picture">
            </div>
            <div>
                <h3 id="user-name">User Name</h3>
                <p class="balance" id="user-balance">$0.00</p>
            </div>
        </div>

        <!-- Ad Section -->
        <div class="mt-4 text-center">
            <button id="show-ad" class="btn btn-primary">Watch Ad for Rewards</button>
        </div>
    </div>

    <!-- Bootstrap JS, Popper.js, and jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/5.3.0/js/bootstrap.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Check if the Telegram WebApp is available
            if (window.Telegram.WebApp) {
                const user = Telegram.WebApp.initDataUnsafe.user;
                if (user) {
                    // Extract Telegram user data
                    const userData = {
                        first_name: user.first_name,
                        last_name: user.last_name,
                        username: user.username,
                        language_code: user.language_code,
                        photo_url: user.photo_url,
                        telegram_id: user.id,
                    };

                    // Display user details on the page
                    document.getElementById("user-name").innerText = userData.username || "User";
                    document.getElementById("user-balance").innerText = "$0.00"; // Placeholder for balance
                    document.getElementById("profile-image").src = userData.photo_url || "default_profile.png";

                    // Send a request to the Laravel route to check or create the user
                    fetch("<?php echo e(route('user.check')); ?>", {
                            method: "POST",
                            headers: {
                                "Content-Type": "application/json",
                                "X-CSRF-Token": document.querySelector('meta[name="csrf-token"]').getAttribute(
                                    "content")
                            },
                            body: JSON.stringify(userData)
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                document.getElementById("user-balance").innerText =
                                    `$${data.user.balance || "0.00"}`;
                            }
                        })
                        .catch(error => console.error("Error:", error));
                }
            }
        });

        // Handle showing the ad and rewarding the user after watching
        document.getElementById("show-ad").addEventListener("click", function() {
            show_8445526().then(() => {
                alert('You have seen the ad! Reward is credited.');
                // Call a Laravel route to update user's reward balance
                fetch("<?php echo e(route('reward.user')); ?>", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            "X-CSRF-Token": document.querySelector('meta[name="csrf-token']
                            ").getAttribute("
                            content ")
                        },
                        body: JSON.stringify({
                            telegram_id: Telegram.WebApp.initDataUnsafe.user.id
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            document.getElementById("user-balance").innerText = `$${data.new_balance}`;
                        }
                    })
                    .catch(error => console.error("Error:", error));
            });
        });
    </script>

</body>

</html>
<?php /**PATH D:\monetag-bot\resources\views/welcome.blade.php ENDPATH**/ ?>